/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.property.dialog;

import filenet.vw.api.VWReceiveInstruction;
import filenet.vw.api.VWWebServiceParameterDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.property.VWAuthPropertyData;
import filenet.vw.toolkit.design.property.VWExpressionTextField;
import filenet.vw.toolkit.design.property.dialog.VWReceiveCorrelationSetPanel;
import filenet.vw.toolkit.design.property.event.IVWExpressionTextFieldListener;
import filenet.vw.toolkit.design.property.event.VWExpressionTextFieldEvent;
import filenet.vw.toolkit.design.property.resources.VWResource;
import filenet.vw.toolkit.utils.IVWPropertyData;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.table.VWLabelListCellRenderer;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class VWReceiveCorrelationSetsPanel
extends JPanel
implements ActionListener,
IVWExpressionTextFieldListener {
    private JPanel m_basicPanel = null;
    private JComboBox m_param = null;
    private VWExpressionTextField m_correlationExpression = null;
    private VWReceiveCorrelationSetPanel m_correlationSetPanel = null;
    private JLabel m_spacerLabel = null;
    private VWAuthPropertyData m_authPropertyData = null;
    private VWReceiveInstruction m_instructionDef = null;

    public VWReceiveCorrelationSetsPanel(VWAuthPropertyData authPropertyData) {
        this.m_authPropertyData = authPropertyData;
        this.init();
    }

    public void setInstructionDefinition(VWReceiveInstruction instructionDef) {
        if (instructionDef != null) {
            this.m_instructionDef = instructionDef;
            this.reinitialize();
        }
    }

    public void reinitialize() {
        if (this.m_instructionDef != null) {
            String csName = this.m_instructionDef.getCorrelationSetName();
            String elementName = this.m_instructionDef.getMessageFromElementName();
            String schemaName = this.m_instructionDef.getMessageFromSchemaName();
            if (csName == null && elementName == null && schemaName == null) {
                this.switchToBasicMode();
            } else {
                this.switchToAdvancedMode();
            }
            this.m_correlationSetPanel.setInstructionDefinition(this.m_instructionDef);
            String correlationExpression = this.m_instructionDef.getCorrelationValueExpression();
            this.m_correlationExpression.setText(correlationExpression);
            this.m_param.removeActionListener(this);
            this.m_param.removeAllItems();
            this.m_param.addItem(VWResource.s_noneItemStr);
            try {
                VWWebServiceParameterDefinition[] params = this.m_instructionDef.getParameterDefinitions();
                if (params != null) {
                    int count = params.length;
                    if (count > 0) {
                        boolean bFound = false;
                        int nParameterIndex = 0;
                        int paramSeqNum = this.m_instructionDef.getCorrelationParameterSequenceNumber();
                        for (int i = 0; i < count; ++i) {
                            this.m_param.addItem(params[i].getName());
                            if (bFound || params[i].getSequenceNumber() != paramSeqNum) continue;
                            nParameterIndex = i + 1;
                            bFound = true;
                        }
                        this.m_param.setSelectedIndex(nParameterIndex);
                    } else {
                        this.m_param.setSelectedIndex(0);
                    }
                }
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
            }
            this.m_param.addActionListener(this);
        }
    }

    public void switchToBasicMode() {
        this.m_basicPanel.setVisible(true);
        this.m_spacerLabel.setVisible(true);
        this.m_correlationSetPanel.setVisible(false);
    }

    public void switchToAdvancedMode() {
        this.m_basicPanel.setVisible(false);
        this.m_spacerLabel.setVisible(false);
        this.m_correlationSetPanel.setVisible(true);
    }

    public void actionPerformed(ActionEvent event) {
        try {
            if (event.getSource().equals(this.m_param)) {
                this.performParamAction();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void textUpdated(VWExpressionTextFieldEvent event) {
        this.performCorrelationExpressionAction();
    }

    private void init() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbCons = new GridBagConstraints();
        gbCons.anchor = 23;
        gbCons.gridx = 0;
        gbCons.gridy = 0;
        gbCons.fill = 2;
        gbCons.weightx = 1.0;
        gbCons.weighty = 0.0;
        gbCons.gridwidth = 1;
        gbCons.gridheight = 1;
        gbCons.insets = new Insets(5, 5, 0, 5);
        this.add((Component)this.getBasicPanel(), gbCons);
        ++gbCons.gridy;
        gbCons.fill = 1;
        gbCons.weighty = 1.0;
        this.m_correlationSetPanel = new VWReceiveCorrelationSetPanel(this.m_authPropertyData);
        this.add((Component)this.m_correlationSetPanel, gbCons);
        ++gbCons.gridy;
        this.m_spacerLabel = new JLabel();
        this.add((Component)this.m_spacerLabel, gbCons);
    }

    private JPanel getBasicPanel() {
        this.m_basicPanel = new JPanel();
        this.m_basicPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbCons = new GridBagConstraints();
        gbCons.anchor = 23;
        gbCons.gridx = 0;
        gbCons.gridy = 0;
        gbCons.fill = 2;
        gbCons.weightx = 1.0;
        gbCons.weighty = 0.0;
        gbCons.gridheight = 1;
        gbCons.gridwidth = 1;
        VWToolbarBorder paramBorder = new VWToolbarBorder(VWResource.s_operationParameterContainsCorrelation);
        JPanel paramPanel = paramBorder.getClientPanel();
        paramPanel.setLayout(new BorderLayout());
        this.m_param = new JComboBox();
        this.m_param.setRenderer(new VWLabelListCellRenderer());
        this.m_param.addActionListener(this);
        paramPanel.add(this.m_param);
        this.m_basicPanel.add((Component)paramBorder, gbCons);
        ++gbCons.gridy;
        VWToolbarBorder correlationExpressionBorder = new VWToolbarBorder(VWResource.s_correlationExpression);
        JPanel correlationExpressionPanel = correlationExpressionBorder.getClientPanel();
        correlationExpressionPanel.setLayout(new BorderLayout());
        this.m_correlationExpression = new VWExpressionTextField(this.m_authPropertyData.getMainContainer(), (IVWPropertyData)this.m_authPropertyData);
        this.m_correlationExpression.addExpressionTextFieldListener(this);
        correlationExpressionPanel.add(this.m_correlationExpression);
        this.m_basicPanel.add((Component)correlationExpressionBorder, gbCons);
        return this.m_basicPanel;
    }

    private void performCorrelationExpressionAction() {
        try {
            if (this.m_instructionDef != null) {
                String expression = this.m_correlationExpression.getText();
                if (expression != null && expression.length() == 0) {
                    expression = null;
                }
                this.m_instructionDef.setCorrelationValueExpression(expression);
                this.m_authPropertyData.setDirty();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void performParamAction() {
        try {
            int paramSeqNum = 0;
            if (this.m_instructionDef != null) {
                Object paramName = this.m_param.getSelectedItem();
                if (paramName != null && paramName instanceof String && VWStringUtils.compare((String)paramName, VWResource.s_noneItemStr) != 0) {
                    paramSeqNum = this.m_param.getSelectedIndex();
                }
                this.m_instructionDef.setCorrelationParameterSequenceNumber(paramSeqNum - 1);
                this.m_authPropertyData.setDirty();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

